
Create or replace procedure get_alertlog_lines (num_lines in number, alertlog out clob)

/*

   This procedure should be owned by SYS, and you should grant
   execute privileges on it to whatever user you connect to your
   database as within Oracletool.

   Oracletool will not display the alertlog menu item unless this
   procedure exists.
   

*/

as

   v_alertlog clob;

Begin

   For i in (
      Select
         indx,
         to_char(originating_timestamp,'MM/DD/YYYY HH24:MI:SS') as timestamp,
         message_text as text
      from X$DBGALERTEXT
         where indx > (Select max(indx)-num_lines from X$DBGALERTEXT) order by indx asc)
   loop
      v_alertlog := v_alertlog||i.timestamp||': '||i.text;
   end loop;

   alertlog := v_alertlog;

End get_alertlog_lines;
/

--
-- Example grant
--
--Grant execute on get_alertlog_lines to SYSTEM;
